{********************************************}
{                                            }
{           JText DLL usage example          }
{					     }	
{    Copyright (c) 1999 by Shamil Nizamov    }
{            All Rights Reserved             }
{                                            }
{                                            }
{********************************************}

unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

const
  exdll='JText00.DLL';
  csUni = 0;
  csSJIS= csUni + 1;

type
  TfrmMain=class(TForm)
    btnNext:TButton;
    btnFile:TButton;
    OpenDialog: TOpenDialog;
    Bevel1: TBevel;
    Label1: TLabel;
    btnClose: TButton;
    procedure FormCreate(Sender:TObject);
    procedure btnNextClick(Sender:TObject);
    procedure btnFileClick(Sender:TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
   {Privatede clarations}
  public
   WordLst:TStringList;
  end;

var
 frmMain:TfrmMain;
 i:word;

implementation

{$R *.DFM}

{exported from JText.dll}

{TextOutJ works well both under Windows95/98 and Windows NT}
function TextOutJ(DC: HDC; X, Y: Integer; lpString: string;
                  CharSet:UINT): boolean; stdcall; external exdll name 'TextOutJ';

{DrawTextJ works well under Windows NT only}
function DrawTextJ(DC: HDC; lpString: string; var lpRect: TRect;
                   uFormat: UINT; CharSet:UINT): Integer; stdcall;
                   external exdll name'DrawTextJ';


{------------------------------------------------------------------------
DESCR:   Allocates memory for a string list
PARAMS:  
RETURNS: 
NOTES:   At least one Japanese true-type font MUST be properly installed
         on your PC. Visit a home directory in order to download one.
	 MS Gothic true-type font currently assigned to the 
         Form.Font property. 
-------------------------------------------------------------------------}
procedure TfrmMain.FormCreate(Sender:TObject);
begin
  WordLst:=TStringList.Create;
  Canvas.Brush.Color:=frmMain.Color;
  Canvas.Font.Assign(frmMain.Font);
  SetBkMode(Canvas.Handle,TRANSPARENT);
end;

{------------------------------------------------------------------------
DESCR:   Releases memory allocated by WordLst string list
PARAMS:  
RETURNS: 
NOTES:   
-------------------------------------------------------------------------}
procedure TfrmMain.FormDestroy(Sender: TObject); begin WordLst.Free end;

{------------------------------------------------------------------------
DESCR:   Fills string list from a file you have selected
PARAMS:  
RETURNS: 
NOTES:   Two test file already located in this directory.	
-------------------------------------------------------------------------}
procedure TfrmMain.btnFileClick(Sender:TObject);
begin  
  OpenDialog.InitialDir:=ExtractFilePath(Application.ExeName);
  if OpenDialog.Execute then WordLst.LoadFromFile(OpenDialog.FileName);
  if WordLst.Count>0 then btnNext.Enabled:=True;
  i:=0;
end;

{------------------------------------------------------------------------
DESCR:   Shows both TextOutJ and DrawTextJ function usage
PARAMS:  
RETURNS: 
NOTES:   Check out differences between evaluation and purchased versions.
-------------------------------------------------------------------------}
procedure TfrmMain.btnNextClick(Sender:TObject);
var
  dRect:TRect;
begin
  {A simplest way to erase everything}
  Canvas.FillRect(Rect(0,0,Width,Height));
  Label1.Refresh;
  Bevel1.Refresh;

  {Draw a title}
  Windows.TextOut(Canvas.Handle,50,100,'TextOutJ  SJIS:',15);
  Windows.TextOut(Canvas.Handle,50,150,'DrawTextJ SJIS:',15);

  {Evaluation version has PREDETERMINATE value of X,Y coordinates!}
  TextOutJ(Canvas.Handle,1000,1000,WordLst[i],csSJIS);

  {Evaluation version has PREDETERMINATE value of X,Y coordinates!}
  dRect:=Rect(1000,1000,Width,Height);
  DrawTextJ(Canvas.Handle,WordLst[i],dRect,DT_LEFT,csSJIS);

  {Take the next string or loop}
  inc(i);
  if i>pred(WordLst.Count) then i:=0;
end;

{------------------------------------------------------------------------
DESCR:   Terminates the program
PARAMS:  
RETURNS: 
NOTES:   
-------------------------------------------------------------------------}
procedure TfrmMain.btnCloseClick(Sender: TObject); begin Close end;

end.
